#include <stdio.h>
#include <stdlib.h>
#include <caca.h>

int main(int argc, char *argv[])
{
	caca_canvas_t *cv;
	caca_display_t *dp;
	caca_event_t ev;

	int i = 0;
	int count = 0;

	dp = caca_create_display(NULL);
	if (!dp)
	{
		fprintf(stderr, "Cannot create caca display !\n");
		return 1;
	}
	else
		cv = caca_get_canvas(dp);

	caca_set_display_title(dp, "Key Events");
	caca_put_str(cv, 0, 0, "Key Events:");
	caca_refresh_display(dp);
	caca_set_display_time(dp, 100000);

	if (argc == 2)
		count = atoi(argv[1]);

	if (count <= 0)
		count = 10;

	while (i <= count)
	{
		caca_get_event(dp, CACA_EVENT_ANY, &ev, -1);
		if (caca_get_event_type(&ev) == CACA_EVENT_KEY_PRESS)
		{
			caca_put_str(cv, 0, i + 1, "- KEY PRESSED");
			i += 1;
		}

		if (caca_get_event_type(&ev) == CACA_EVENT_KEY_RELEASE)
		{
			caca_put_str(cv, 0, i + 1, "- KEY RELEASED");
			i += 1;
		}

		caca_refresh_display(dp);
	}

	caca_free_display(dp);
	return 0;
}

